using namespace std;
#include <exception>
#include "PlatformLayerLinux.h"
#include <fcntl.h>
#include <stdint.h>
#include <sys/ioctl.h>

#define GET_DEVICE_DESCRIPTOR           0x0001
#define SET_DESC_INDEX                  0x0002
#define SET_IN_ENDPOINT                 0x0003
#define SET_OUT_ENDPOINT                0x0004
#define GET_ENDPOINT_DESCRIPTOR         0x0005
#define GET_INTERFACE_DESCRIPTOR        0x0006
#define GET_CONFIGURATION_DESCRIPTOR    0x0007
#define SET_TRANSFER_TYPE               0x0008
#define SET_TIMEOUT                     0x0009
#define GET_STRING_DESCRIPTOR           0x000a
#define DEBUG_STRING_DESCRIPTOR         0x000b

platformLayerLinux::platformLayerLinux() {

    platform = 2;
    vid = (short)0x04d8;
    pid = (short)0x000c;
    findDevices();
}

platformLayerLinux::~platformLayerLinux() {

    l->printLog("platformLayerLinux Destructor",true,true);
    l = NULL;
}

void platformLayerLinux::findDevices() {

    // Debe buscar los archivos usb4all (ex skel).
    // Abrir uno por uno y obtener sus descriptores y almacenarlos en el struct itemDsc
    // Agregar el itemDsc al map descriptors.
    int fd, io, ioparam;
    struct usb_device_descriptor ddsc;
    struct usb_config_descriptor cdsc;
    struct usb_interface_descriptor idsc;
    struct usb_endpoint_descriptor edsc;
    struct usb_string_descriptor sdsc;
    itemDsc itd;
    unsigned char str[255];

    try {
    itd.port = "/dev/usb4all0";
    fd  = open("/dev/usb4all0", O_RDWR);
    itd.fd = fd;

    ioparam = 0;
    ioctl(fd, SET_DESC_INDEX, &ioparam);
    io = ioctl(fd, GET_DEVICE_DESCRIPTOR, (&ddsc));
    for (int i = 0; i<USB_DT_INTERFACE_SIZE	; i++){
        itd.stdDeviceDsc[i] = *(((unsigned char*)&ddsc) + i);
    }

    ioparam = ddsc.iManufacturer;
    ioctl(fd, SET_DESC_INDEX, &ioparam);
    io = ioctl(fd, GET_STRING_DESCRIPTOR, (&sdsc));
    for (int i = 0; i<255 ; i++){
        itd.strManufacturer[i] = *(((unsigned char*)&sdsc) + i);
    }
    ioparam = ddsc.iProduct;
    ioctl(fd, SET_DESC_INDEX, &ioparam);
    io = ioctl(fd, GET_STRING_DESCRIPTOR, (&sdsc));
    for (int i = 0; i<255 ; i++){
        itd.strProduct[i] = *(((unsigned char*)&sdsc) + i);
    }
    ioparam = ddsc.iSerialNumber;
    ioctl(fd, SET_DESC_INDEX, &ioparam);
    io = ioctl(fd, DEBUG_STRING_DESCRIPTOR, (&str));
    for (int i = 0; i<255 ; i++){
        itd.strSerialNumber[i] = str[i];
    }
    ioparam = 0;
    ioctl(fd, SET_DESC_INDEX, &ioparam);
    io = ioctl(fd, GET_CONFIGURATION_DESCRIPTOR, &cdsc);
    for (int i = 0; i < 9; i++) {
        itd.stdConfigurationDsc[i] = *(((unsigned char*)&cdsc) + i);
    }
    ioparam = 0;
    ioctl(fd, SET_DESC_INDEX, &ioparam);
    io = ioctl(fd, GET_INTERFACE_DESCRIPTOR, &idsc);
    for (int i = 0; i < 9; i++) {
        itd.stdInterfaceDsc[i] = *(((unsigned char*)&idsc) + i);
    }
    itd.qtyep = (int) itd.stdInterfaceDsc[4];
    for (int i = 0 ; i < itd.qtyep ; i++) {
        ioparam = i;
        ioctl(fd, SET_DESC_INDEX, &ioparam);
        io = ioctl(fd, GET_ENDPOINT_DESCRIPTOR, &edsc);
        for (int j = 0 ; j < 7 ; j++) {
            itd.stdEndpointDsc[i][j] = *(((unsigned char*)&edsc) + j);
        }
    }
    descriptors.insert(pair<int,itemDsc>(0,itd));
    }
    catch (exception& e) {
        printf("Error: %s\n", e.what());
        close(fd);
    }
}

map<int,itemDsc> platformLayerLinux::getDescriptors() {

    return descriptors;
}
